
function attachEventListener(target, eventType, functionRef, capture)
{
    if (typeof target.addEventListener != "undefined")
    {
        target.addEventListener(eventType, functionRef, capture);
    }
    else if (typeof target.attachEvent != "undefined")
    {
        target.attachEvent("on" + eventType, functionRef);
    }
    else
    {
        eventType = "on" + eventType;

        if (typeof target[eventType] == "function")
        {
            var oldListener = target[eventType];

            target[eventType] = function()
            {
                oldListener();

                return functionRef();
            }
        }
        else
        {
            target[eventType] = functionRef;
        }
    }

    return true;
};




function detachEventListener(target, eventType, functionRef, capture)
{
    if (typeof target.removeEventListener != "undefined")
    {
        target.removeEventListener(eventType, functionRef, capture)
    }
    else if (typeof target.detachEvent != "undefined")
    {
        target.detachEvent("on" + eventType, functionRef);
    }
    else
    {
        target["on" + eventType] = null;
    }

    return true;
}




function getEventTarget(event)
{
    var targetElement = null;

    if (typeof event.target != "undefined")
    {
        targetElement = event.target;
    }
    else
    {
        targetElement = event.srcElement;
    }

    while (targetElement.nodeType == 3 && targetElement.parentNode != null)
    {
        targetElement = targetElement.parentNode;
    }

    return targetElement;
}




function stopEvent(event)
{
    if (typeof event.stopPropagation != "undefined")
    {
        event.stopPropagation();
    }
    else
    {
        event.cancelBubble = true;
    }

    return true;
}




function stopDefaultAction(event)
{
    event.returnValue = false;

    if (typeof event.preventDefault != "undefined")
    {
        event.preventDefault();
    }

    return true;
}




function getScrollingPosition()
{
	//array for X and Y scroll position
	var position = [0, 0];

	//if the window.pageYOffset property is supported
	if(typeof window.pageYOffset != 'undefined')
	{
		//store position values
		position = [
			window.pageXOffset,
			window.pageYOffset
			];
	}

	//if the documentElement.scrollTop property is supported
	//and the value is greater than zero
	if(typeof document.documentElement.scrollTop != 'undefined'
		&& document.documentElement.scrollTop > 0)
	{
		//store position values
		position = [
			document.documentElement.scrollLeft,
			document.documentElement.scrollTop
			];
	}

	//if the body.scrollTop property is supported
	else if(typeof document.body.scrollTop != 'undefined')
	{
		//store position values
		position = [
			document.body.scrollLeft,
			document.body.scrollTop
			];
	}

	//return the array
	return position;
};



function getElementsByAttribute(attribute, attributeValue)
{
	var elementArray = new Array();
	var matchedArray = new Array();

	if (document.all)
	{
		elementArray = document.all;
	}
	else
	{
		elementArray = document.getElementsByTagName("*");
	}

	for (var i = 0; i < elementArray.length; i++)
	{
		if ((attribute == "class" && elementArray[i].className == attributeValue) || (elementArray[i].getAttribute(attribute) == attributeValue))
		{
			matchedArray[matchedArray.length] = elementArray[i];
		}
	}
	
	return matchedArray;
}




function getPosition(theElement)
{
    var positionX = 0;
    var positionY = 0;

    while (theElement != null)
    {
        positionX += theElement.offsetLeft;
        positionY += theElement.offsetTop;
        theElement = theElement.offsetParent;
    }

    return [positionX, positionY];
}




function retrieveComputedStyle(element, styleProperty)
{
    var computedStyle = null;

    if (typeof element.currentStyle != "undefined")
    {
        computedStyle = element.currentStyle;
    }
    else
    {
        computedStyle = document.defaultView.getComputedStyle(element, null);
    }

    return computedStyle[styleProperty];
}

function identifyBrowser()
{
    var agent = navigator.userAgent.toLowerCase();

    if (typeof navigator.vendor != "undefined" && navigator.vendor == "KDE")
    {
        var splitKDE= agent.split("konqueror/");
        var KDEVersion = splitKDE[1].split("; ")[0];
        KDEVersion = parseFloat(KDEVersion);

        if (KDEVersion >= 3.2)
        {
            return "kde";
        }
    }
    else if (typeof window.opera != "undefined")
    {
        if (agent.match(/opera[\/ ]5/))
        {
            return "opera5";
        }
        else if (agent.match(/opera[\/ ]6/))
        {
            return "opera6";
        }
        else if (agent.match(/opera[\/ ][7]/))
        {
            return "opera7";
        }
        else if (agent.match(/opera[\/ ][8]/))
        {
            return "opera8";
        }
    }
    else if (typeof document.all != "undefined")
    {
        if(typeof document.getElementById != "undefined")
        {
            if (agent.indexOf("msie 6") != -1)
            {
                return "ie6";
            }
            else
            {
                if (typeof document.body.style.scrollbarTrackColor != "undefined")
                {
                    return "ie5.5";
                }

                return "ie5";
            }
        }
        else
        {
            return "ie4";
        }
    }
    else if (typeof document.getElementById != "undefined")
    {
        if (agent.indexOf("gecko") != -1)
        {
			if (agent.indexOf("safari") != -1 || (typeof document.childNodes != "undefined" && typeof document.all == "undefined" && typeof navigator.taintEnabled == "undefined"))
			{
				if (typeof window.XMLHttpRequest)
				{
					return "safari1.2";
				}

				return "safari1";
			}

            return "mozilla";
        }
    }

    return false;
}




function identifyOS()
{
    var agent = navigator.userAgent.toLowerCase();

    if (agent.indexOf("win") != -1)
    {
        return "win";
    }
    else if (agent.indexOf("mac"))
    {
        return "mac";
    }
    else
    {
        return "unix";
    }

    return false;
}